/*---------------------------------------------------------
 GBAMP Firmware flasher
 Written by DarkFader
 
 flashapp.cpp
---------------------------------------------------------*/


/*
 * NDS/GBA
 */
#ifdef ARM9		// assume NDS
	#include "nds.h"
	
	#define ScanKeys		scanKeys
	#define KeysInit		keysInit
	#define KeysHeld		keysHeld
	#define KeysDown		keysDown
	#define KeysUp			keysUp
	#define VBlankIntrWait	swiWaitForVBlank
#else
	#include "gba_base.h"
	#include "gba_input.h"
	#include "gba_interrupt.h"
	#include "gba_systemcalls.h"
#endif

/*
 * Includes
 */
#include "flash.h"
#include "loader_bin.h"
#include "repair_bin.h"

/*
 * Imports
 */
int xprintf(char *fmt...);
void gotoxy(int x, int y);

#include "setarm9_reg_waitcr.h"

//---------------------------------------------------------------
// CF Addresses & Commands

#define GAME_PAK		0x08000000			// Game pack start address

#define CF_REG_STS		*(vu16*)(GAME_PAK + 0x018C0000)	// Status of the CF Card / Device control
#define CF_REG_CMD		*(vu16*)(GAME_PAK + 0x010E0000)	// Commands sent to control chip and status return
#define CF_REG_ERR		*(vu16*)(GAME_PAK + 0x01020000)	// Errors / Features

#define CF_REG_SEC		*(vu16*)(GAME_PAK + 0x01040000)	// Number of sector to transfer
#define CF_REG_LBA1		*(vu16*)(GAME_PAK + 0x01060000)	// 1st byte of sector address
#define CF_REG_LBA2		*(vu16*)(GAME_PAK + 0x01080000)	// 2nd byte of sector address
#define CF_REG_LBA3		*(vu16*)(GAME_PAK + 0x010A0000)	// 3rd byte of sector address
#define CF_REG_LBA4		*(vu16*)(GAME_PAK + 0x010C0000)	// last nibble of sector address | 0xE0

#define CF_DATA			(vu16*)(GAME_PAK + 0x01000000)		// Pointer to buffer of CF data transered from card

// Card status
#define CF_STS_INSERTED		0x50
#define CF_STS_REMOVED		0x00
#define CF_STS_READY		0x58

#define CF_STS_DRQ			0x08
#define CF_STS_BUSY			0x80

// Card commands
#define CF_CMD_LBA			0xE0
#define CF_CMD_READ			0x20
#define CF_CMD_WRITE		0x30

#define CARD_TIMEOUT	10000000

#define BYTE_PER_READ 512

/*-----------------------------------------------------------------
CF_IsInserted
Is a compact flash card inserted?
bool return OUT:  true if a CF card is inserted
-----------------------------------------------------------------*/
bool CF_IsInserted (void) 
{
	// Change register, then check if value did change
	CF_REG_STS = CF_STS_INSERTED;
	return (CF_REG_STS == CF_STS_INSERTED);
}

/*
 * FlashApp
 */
void FlashApp()
{
	xprintf("GBA Movie Player flasher v1.2\n");
	xprintf(" by Rafael Vuijk (DarkFader) \n");
	xprintf("NDSMP - GBAMP FW Hack v2.11  \n");
	xprintf(" NDS support for GBAMP       \n");
	xprintf(" by Michael Chisholm (Chishm)\n");
	xprintf("MicroDrive support beta1     \n");
	xprintf(" 2006/04/16 by Moonlight.    \n");
	xprintf("\n");

	while (1)
	{
		int i;
		
		gotoxy(0,8);
		
		VBlankIntrWait();
		SetARM9_REG_WaitCR();
		VBlankIntrWait();
		if(CF_IsInserted()==false){
			xprintf("CF not detected!              \n");
			}else{
			xprintf("CF detected!                  \n");
		}
		VBlankIntrWait();
		FlashUnlock();
		VBlankIntrWait();
		unsigned int id = FlashID();
		
		if ((id & FLASHID_MANUFACTURER) == FLASHID_SST)
		{
			xprintf("Flash detected!     (%08X)\n", id);
			xprintf("To flash, hold L+R and press  \n");
			xprintf("  SELECT for bootstrap loader.\n");
			xprintf("  START for repair utility.   \n");

			ScanKeys();
			unsigned int held = KeysHeld();
			unsigned int down = KeysDown();
			if (((held & (KEY_L | KEY_R)) == (KEY_L | KEY_R)) && ((down == KEY_START) || (down == KEY_SELECT)))
//			if ((down == KEY_START) || (down == KEY_SELECT))
			{
				int verify = -2;

				while (verify < 0)
				{
					if (down == KEY_SELECT)
					{
						if ((u32)loader_bin_size != 0x4000)
						{
							xprintf("Bootstrap loader is wrong size.\nAborting... ");
							verify = 0;
						}
						else
						{
							xprintf("Erasing... ");
							FlashEraseBootBlock();
							xprintf("done.\n");
							
							if (verify == -2) xprintf("Programming %u bytes...", (u32)loader_bin_size);
							RomProgram((u16 *)loader_bin, 0, (u32)loader_bin_size);
							verify = RomVerify((u16 *)loader_bin, 0, (u32)loader_bin_size);
						}
					}
					else if (down == KEY_START)
					{
						xprintf("blocked repair image. please use official writer.");
						while(1);
						
						xprintf("Erasing... ");
						FlashEraseChip();
						xprintf("done.\n");
				
						if (verify == -2) xprintf("Programming %u bytes...", (u32)repair_bin_size);
						RomProgram((u16 *)repair_bin, 0, (u32)repair_bin_size);
						verify = RomVerify((u16 *)repair_bin, 0, (u32)repair_bin_size);
					}
					if (verify < 0) for (int i=0; i<100; i++) VBlankIntrWait();		// wait before retry
				}

				xprintf("done.\n");
				xprintf("It is now safe to turn off\nyour computer.\n");

				break;
			}
		}
		else
		{
			xprintf("Flash NOT detected! (%08X)\n", id);
			
			ScanKeys();
			unsigned int held = KeysHeld();
			unsigned int down = KeysDown();
			if (((held & (KEY_L)) == (KEY_L))){
			  xprintf("wait... Please insert adapter.\n");
			  xprintf("                              \n");
			  xprintf("                              \n");
			  while(1){
			    ScanKeys();
			    unsigned int held = KeysHeld();
			    if (((held & (KEY_L)) != (KEY_L))) break;
			  }
			  }else{
			  xprintf("Press Sholder Left button.    \n");
			  xprintf("                              \n");
			  xprintf("                              \n");
			}
		}
	}
}
