

#include "segalib.h"
#include "ssf.h"

#define DISK_ERR_RD1 0xD2
#define DISK_ERR_RD2 0xD3 //retrun from bios

#define CMD0  0x40    /*software reset*/
#define CMD1  0x41    /*brings card out of idle state*/
#define CMD8  0x48    /*Reserved*/
#define CMD12 0x4C    /*stop transmission on multiple block read*/
#define CMD17 0x51    /*read single block*/
#define CMD18 0x52    /*read multiple block*/
#define CMD58 0x7A    /*reads the OCR register*/
#define CMD55 0x77
#define CMD41 0x69
#define CMD23 0x57
#define CMD24 0x58    /*writes a single block*/
#define CMD25 0x59    /*writes a single block*/

u8 diskCmd(u8 cmd, u32 arg) {

    u16 i = 0;
    u8 resp;


    ssf_spi_ss_on();
    ssf_spi(0xff);
    ssf_spi(cmd);
    ssf_spi(arg >> 24);
    ssf_spi(arg >> 16);
    ssf_spi(arg >> 8);
    ssf_spi(arg);
    ssf_spi(0x95);
    ssf_spi(0xff);
    resp = ssf_spi(0xff);

    while (resp == 0xff) {
        resp = ssf_spi(0xff);
        if (i++ == 2048)break;
    }

    ssf_spi_ss_off();
    return resp;
}

void diskCloseRW() {

    ssf_spi_ss_off();
    diskCmd(CMD12, 0);
}

u8 diskOpenRead(u32 saddr) {

    u8 resp;
    if (ssf_card_type() == 0)saddr *= 512;

    resp = diskCmd(CMD18, saddr);
    if (resp != 0)return DISK_ERR_RD1;
    ssf_spi_ss_on();

    return 0;
}

//disk addr and lenght in sectors (sector = 512 bytes)

u8 diskRead(u32 sd_addr, void *dst, u16 slen) {

    u8 *dst8 = (u8 *) dst;
    u8 resp = 0;
    u16 i;

    resp = diskOpenRead(sd_addr);
    if (resp)return resp;

    while (slen != 0) {

        //wait for block begin
        for (i = 0; i < 0xffff; i++) {
            if (ssf_spi(0xff) == 0xfe)break;
        }
        
        if (i == 0xffff) {
            diskCloseRW();
            return DISK_ERR_RD2; //timeout
        }

        //read sector
        for (i = 0; i < 512; i++)*dst8++ = ssf_spi(0xff);

        //read crc16
        ssf_spi(0xff);
        ssf_spi(0xff);
        slen--;

    }

    diskCloseRW();

    return resp;

}

u8 diskReadFast(u32 sd_addr, void *dst, u16 slen) {

    u16 *dst16 = (u16 *) dst;
    u8 resp = 0;
    u16 i;

    resp = diskOpenRead(sd_addr);
    if (resp)return resp;

    while (slen != 0) {

        //wait for block begin
        for (i = 0; i < 0xffff; i++) {
            if (ssf_spi(0xff) == 0xfe)break;
        }
        if (i == 0xffff) {
            diskCloseRW();
            return DISK_ERR_RD2; //timeout
        }


        ssf_spi_qrd_on();

        //first dumy read. copy data to internal fpga buffer
        ssf_spi_qrd();

        //read sector
        for (i = 0; i < 256; i++)*dst16++ = ssf_spi_qrd();

        ssf_spi_qrd_off();

        //read crc16 (not need in qrd mode)
        //ssf_spi(0xff);
        //ssf_spi(0xff);
        slen--;

    }

    diskCloseRW();

    return resp;

}
