/*
 * File:   main.c
 * Author: krikzz
 *
 * Created on 23.06.2010
 */

#include "segalib.h"
#include "ssf.h"

void JOY_init();
u16 JOY_readJoypad();
void JOY_waitAct();
volatile u16 joy;

#define JOY_DATA *((volatile u8 *) 0xa10003)
#define JOY_CONTROL *((volatile u8 *) 0xa10009)
#define BUTTON_UP       0x0001
#define BUTTON_DOWN     0x0002
#define BUTTON_LEFT     0x0004
#define BUTTON_RIGHT    0x0008
#define BUTTON_A        0x0040
#define BUTTON_B        0x0010
#define BUTTON_C        0x0020
#define BUTTON_START    0x0080
#define BUTTON_X        0x0100
#define BUTTON_Y        0x0200
#define BUTTON_Z        0x0400
#define BUTTON_MODE     0x0800



void testLed();
void testUsb();
u8 testDsik();
void testRom();
void testMath();
void testRamSize();

int main() {

    u16 selector = 0;
    u16 menu_size = 0;
    u16 i;
    u8 resp;

    static u8 * menu_str[8];
    menu_str[menu_size++] = "test led";
    menu_str[menu_size++] = "test usb";
    menu_str[menu_size++] = "read disk";
    menu_str[menu_size++] = "ROM r/w test";
    menu_str[menu_size++] = "math test";
    menu_str[menu_size++] = "test ram size";



    gInit();
    JOY_init();
    ssf_init();


    gCleanScreen();
    for (;;) {

        gSetPal(0);
        gDrawString("Extended SSF demo sample", 7, 3);

        for (i = 0; i < menu_size; i++) {

            if (selector == i) {
                gSetPal(1);
            } else {
                gSetPal(0);
            }
            gDrawString(menu_str[i], 14, 10 + i);
        }


        JOY_waitAct();

        if ((joy & BUTTON_UP))selector = selector == 0 ? menu_size - 1 : selector - 1;
        if ((joy & BUTTON_DOWN))selector = selector == menu_size - 1 ? 0 : selector + 1;

        if ((joy & BUTTON_A)) {

            gSetPal(0);
            if (selector == 0)testLed();
            if (selector == 1)testUsb();
            if (selector == 2) {

                resp = testDsik();
                if (resp) {
                    gCleanScreen();
                    gDrawString("disk error: ", 14, 10);
                    gAppendHex8(resp);
                    JOY_waitAct();
                }
            }
            if (selector == 3)testRom();
            if (selector == 4)testMath();
            if (selector == 5)testRamSize();

            gCleanScreen();
        }

    }



    return 0;
}

void testLed() {

    u16 led_state = 0;
    gCleanScreen();
    ssf_led_off();

    for (;;) {

        gDrawString("LED ", 14, 10);
        if (led_state == 0) {
            gAppendString("OFF");
        } else {
            gAppendString("ON ");
        }

        JOY_waitAct();

        if ((joy & BUTTON_A))led_state ^= 1;
        if ((joy & BUTTON_B))return;

        if (led_state == 0) {
            ssf_led_off();
        } else {
            ssf_led_on();
        }

    }

}

void testUsb() {

    u16 i;
    u8 dat;
    u8 *tx_str = "Hello world!";
    gCleanScreen();
    gDrawString("Push A to send \"Hello\" string to PC", 2, 25);
    gDrawString("received data:", 2, 2);
    gDrawString(":", 2, 3);

    while (JOY_readJoypad() != 0);

    for (;;) {

        JOY_readJoypad();
        if ((joy & BUTTON_B))return;

        if ((joy & BUTTON_A)) {

            for (i = 0; tx_str[i] != 0; i++) {
                while (ssf_usb_wr_ready() == 0);
                ssf_usb_write(tx_str[i]);
            }

            while (JOY_readJoypad() != 0);
        }

        if (ssf_usb_rd_ready()) {
            dat = ssf_usb_read();
            gAppendChar(dat);
        }

    }
}

#define FAT_TYPE_16 1
#define FAT_TYPE_32 2

u8 getFatType(u8 *fat_data) {

    if (fat_data[0x36] == 'F' && fat_data[0x37] == 'A' && fat_data[0x38] == 'T') {
        return FAT_TYPE_16;
    } else if (fat_data[0x52] == 'F' && fat_data[0x53] == 'A' && fat_data[0x54] == 'T') {
        return FAT_TYPE_32;
    }

    return 0;
}

u8 diskRead(u32 sd_addr, void *dst, u16 slen);
u8 diskReadFast(u32 sd_addr, void *dst, u16 slen);

u8 testDsik() {

    u16 i;
    u8 resp = 0;
    u8 buff[512];
    u32 fat_pbr_entry = 0;
    u32 sectors_per_fat;
    u16 fat_type;
    u32 root_entry;
    u32 reserved_sectors;

    gCleanScreen();

    resp = diskRead(0, buff, 1);
    if (resp)return resp;

    fat_type = getFatType(buff);
    if (fat_type == 0) {

        fat_pbr_entry = buff[0x1c6];
        fat_pbr_entry |= buff[0x1c7] << 8;
        fat_pbr_entry |= (u32) buff[0x1c8] << 16;
        fat_pbr_entry |= (u32) buff[0x1c9] << 24;
        resp = diskRead(fat_pbr_entry, buff, 1);
        if (resp)return resp;

        fat_type = getFatType(buff);
    }

    if (fat_type == FAT_TYPE_16) {
        sectors_per_fat = buff[0x16] | (buff[0x17] << 8);
    } else {
        sectors_per_fat = buff[0x24] | (buff[0x25] << 8) | ((u32) buff[0x26] << 16) | ((u32) buff[0x27] << 24);
    }

    reserved_sectors = buff[0x0e] | (buff[0x0f] << 8);
    root_entry = sectors_per_fat * 2 + fat_pbr_entry + reserved_sectors;


    gSetPal(1);
    gDrawString("Boot sector data: ", 2, 2);
    gSetPal(0);
    gDrawString("", 2, 3);
    for (i = 0; i < 512; i++) {
        if (i % 32 == 0)gDrawString("", 2, 3 + i / 32);
        gAppendChar(buff[i]);
    }

    JOY_waitAct();
    gCleanScreen();

    gSetPal(1);
    gDrawString("Root dir data: ", 2, 2);
    gSetPal(0);
    gDrawString("", 2, 3);
    resp = diskReadFast(root_entry, buff, 1);
    if (resp)return resp;
    for (i = 0; i < 512; i++) {
        if (i % 32 == 0)gDrawString("", 2, 3 + i / 32);
        gAppendChar(buff[i]);
    }

    JOY_waitAct();

    return 0;
}

void testRom() {

    u8 error;
    u8 x = 2;
    u8 y = 2;
    volatile u8 *ptr8 = (u8 *) 0x100000;
    volatile u16 *ptr16 = (u16 *) 0x100000;
    gCleanScreen();

    ssf_rom_wr_on();


    error = 0;
    gDrawString("16bit wr: ", x, y++);
    *ptr16 = 0xffff;
    if (*ptr16 != 0xffff)error = 1;
    *ptr16 = 0x1234;
    if (*ptr16 != 0x1234)error = 1;
    if (error) {
        gAppendString("error");
    } else {
        gAppendString("ok");
    }

    error = 0;
    gDrawString("8 bit wr: ", x, y++);
    ptr8[0] = 0xab;
    if (ptr8[0] != 0xab)error = 1;
    ptr8[1] = 0xcd;
    if (ptr8[1] != 0xcd)error = 1;
    if (*ptr16 != 0xabcd)error = 1;
    if (error) {
        gAppendString("error");
    } else {
        gAppendString("ok");
    }

    ssf_rom_wr_off();

    JOY_waitAct();

}

void testMath() {

    u16 i;
    u8 x = 2;
    u8 y = 2;
    u32 rez1;
    u32 rez2;
    u32 *ptr32 = (u32 *) 0x200;
    u16 *ptr16 = (u16 *) 0x200;

    gCleanScreen();

    gDrawString("mul32: ", x, y++);
    for (i = 0; i < 128; i += 2) {
        rez1 = ssf_mul32(ptr32[i], ptr32[i + 1]);
        rez2 = ptr32[i] * ptr32[i + 1];
        if (rez1 != rez2)break;
    }

    if (i == 128) {
        gAppendString(" OK");
    } else {
        gAppendString(" ERROR");
    }


    gDrawString("mul16: ", x, y++);
    for (i = 0; i < 128; i += 2) {
        rez1 = ssf_mul16(ptr16[i], ptr16[i + 1]);
        rez2 = (ptr16[i] * ptr16[i + 1]) & 0xffff;
        if (rez1 != rez2)break;
    }

    if (i == 128) {
        gAppendString(" OK");
    } else {
        gAppendString(" ERROR");
    }


    gDrawString("div32: ", x, y++);
    for (i = 0; i < 128; i += 2) {
        if (ptr32[i + 1] == 0)continue;
        rez1 = ssf_div32(ptr32[i], ptr32[i + 1]);
        rez2 = ptr32[i] / ptr32[i + 1];
        if (rez1 != rez2)break;
    }

    if (i == 128) {
        gAppendString(" OK");
    } else {
        gAppendString(" ERROR ");

    }


    gDrawString("div16: ", x, y++);
    for (i = 0; i < 128; i += 2) {
        if (ptr16[i + 1] == 0)continue;
        rez1 = ssf_div16(ptr16[i], ptr16[i + 1]);
        rez2 = ptr16[i] / ptr16[i + 1];
        if (rez1 != rez2)break;
    }

    if (i == 128) {
        gAppendString(" OK");
    } else {
        gAppendString(" ERROR ");
    }



    JOY_waitAct();

}

void testRamSize() {

    gCleanScreen();
    u16 tmp1;
    u16 tmp2;
    u16 size = 2;
    volatile u16 *ptr1 = (u16 *) 0x00000;
    volatile u16 *ptr2 = (u16 *) 0x80000;

    tmp1 = *ptr1;

    ssf_rom_wr_on();
    for (;;) {

        ssf_set_rom_bank(1, size);
        *ptr2 = *ptr2 + 1;
        tmp2 = *ptr1;
        *ptr2 = *ptr2 - 1;
        if (tmp1 != tmp2)break;
        size++;
        if (size == 0)break;
    }
    ssf_rom_wr_off();

    gDrawString("RAM size: ", 12, 10);
    size /= 2;
    gAppendHex8((size / 10 << 4) | size % 10);
    gAppendString(" MB");

    ssf_set_rom_bank(1, 1);

    JOY_waitAct();

}

void JOY_init() {

    volatile u8 *pb;

    pb = (u8 *) 0xa10009;
    *pb = 0x40;
    pb += 2;
    *pb = 0x40;

}

u16 JOY_readJoypad() {


    gVsync();

    JOY_DATA = 0x40;
    asm("nop");
    asm("nop");
    asm("nop");
    joy = (JOY_DATA & 0x3f);

    JOY_DATA = 0;

    asm("nop");
    asm("nop");
    asm("nop");
    joy |= (JOY_DATA & 0x30) << 2;
    joy ^= 0xff;
    return joy;
}

void JOY_waitAct() {
    while (JOY_readJoypad() != 0);
    while (JOY_readJoypad() == 0);
}

void vb() {


    //vblank interrupt
}

//hsync

void hb() {
    //hblank interrupt
}

//other interrupts

void in() {
    //all other interrupts
}
