
module map_2 //UxROM
(map_out, cpu_dat, cpu_addr, cpu_ce, cpu_rw, m2,
ppu_dat, ppu_addr, ppu_oe, ppu_we, 
clk, map_cfg, rst);
 
	
	output [48:0]map_out;
 
	//cpu bus
	input [7:0]cpu_dat;
	input [14:0]cpu_addr;
	input cpu_ce, cpu_rw, m2;
	
	//ppu bus
	input [7:0]ppu_dat;
	input [13:0]ppu_addr;
	input ppu_oe, ppu_we;
	
	input clk, rst;
	input [7:0]map_cfg;
	
	//mapper outputs
	wire ciram_a10, ciram_ce;
	wire [19:0]prg_addr;
	wire [19:0]chr_addr;
	wire prg_we;
	wire chr_we;
	wire irq;
	wire rom_ce;
	wire ram_ce;
	wire chr_ce;
	
	wire snd = 1'bzz;
	assign map_out[48:0] = {snd, chr_ce, ram_ce, rom_ce, irq, chr_we, prg_we, ciram_ce, ciram_a10, chr_addr[19:0], prg_addr[19:0]};
	//*************************************************************
	wire ram_area = cpu_addr[14:13] == 2'b11 & cpu_ce;
	assign prg_we = !cpu_rw & ram_ce;
	assign chr_we = map_cfg[7] ? !ppu_we & ciram_ce : 0;//if map_cfg[7] == 1 means that we don't have CHR rom, only CHR ram
	assign ram_ce = ram_area & m2;
	assign rom_ce = !cpu_ce;
	assign chr_ce = ciram_ce;
	
	assign ciram_a10 = map_cfg[0] ? ppu_addr[10] : ppu_addr[11];
	assign ciram_ce = !ppu_addr[13];
	
	assign prg_addr[12:0] = cpu_addr[12:0];
	assign chr_addr[12:0] = ppu_addr[12:0];
	
	//Game should not write to upper 64K of battery ram, it may damage os code. 
	//So we pull upper lines of address to zero if not a rom area (cpu_ce == 1)
	assign prg_addr[13] = cpu_ce ? 0 : cpu_addr[13];
	assign prg_addr[17:14] = cpu_ce ? 0 : !cpu_addr[14] ? prg_bank[3:0] : 4'b1111;
	
	reg [3:0]prg_bank;
	reg vram_bit;

	
	always @(negedge m2)
	begin
		
		if(!cpu_ce & !cpu_rw)
		begin
			prg_bank[3:0] <= cpu_dat[3:0];
			vram_bit <= cpu_dat[4];
		end
		
	end

	
endmodule
