

module map_11 //colordreams
(map_out, cpu_dat, cpu_addr, cpu_ce, cpu_rw, m2,
ppu_dat, ppu_addr, ppu_oe, ppu_we, 
clk, map_cfg, rst);
 
	
	output [48:0]map_out;
 
	//cpu bus
	input [7:0]cpu_dat;
	input [14:0]cpu_addr;
	input cpu_ce, cpu_rw, m2;
	
	//ppu bus
	input [7:0]ppu_dat;
	input [13:0]ppu_addr;
	input ppu_oe, ppu_we;
	
	input clk, rst;
	input [7:0]map_cfg;
	
	//mapper outputs
	wire ciram_a10, ciram_ce;
	wire [19:0]prg_addr;
	wire [19:0]chr_addr;
	wire prg_we;
	wire chr_we;
	wire irq;
	wire rom_ce;
	wire ram_ce;
	wire snd = 1'bzz;
	
	assign map_out[48:0] = {snd, chr_ce, ram_ce, rom_ce, irq, chr_we, prg_we, ciram_ce, ciram_a10, chr_addr[19:0], prg_addr[19:0]};
	//*************************************************************
	wire chr_ram_on = map_cfg[7];
	assign prg_we = 0;
	assign chr_we = chr_ram_on ? !ppu_we & ciram_ce : 0;
	assign ram_ce = 0;
	assign rom_ce = !cpu_ce;
	assign chr_ce = ciram_ce;
	
	assign ciram_a10 = map_cfg[0] ? ppu_addr[10] : ppu_addr[11];
	assign ciram_ce = !ppu_addr[13];
	
	assign prg_addr[14:0] = cpu_addr[14:0];
	assign prg_addr[16:15] = prg_bank[1:0];
	
	assign chr_addr[12:0] = ppu_addr[12:0];
	assign chr_addr[16:13] = chr_ram_on ? 4'b0000 : chr_bank[3:0];

	reg [1:0]prg_bank;
	reg [3:0]chr_bank;
	
	always @(negedge m2)
	begin
		
		if(rst)
		begin
			prg_bank <= 0;
			chr_bank <= 0;
		end
			else
		if(!cpu_ce & !cpu_rw)
		begin
			prg_bank[1:0] <= cpu_dat[1:0];
			chr_bank[3:0] <= cpu_dat[7:4];
		end
		
	end
	
	
endmodule