

#include "tools_.h"
#include "lib/types.h"
#include "lib/vdp.h"
#include "fat16_.h"
#include "hard_.h"
#include "mmc_.h"
#include "lib/joy.h"
#include "lib/string.h"
#include "globals_.h"

u8 str_buff[41];

void drawNum(u8 *coment, u32 num, u16 base, u8 x, u8 y) {

    u8 comment_len = 0;
    while (coment[comment_len] != 0) {
        str_buff[comment_len] = coment[comment_len];
        comment_len++;
    }
    STR_intToDecString(num, &str_buff[comment_len]);
    VDP_drawText(APLAN, str_buff, base, x, y);
}

void drawDir(u8 x, u8 y, u16 selectror, u8 items) {

    u8 i;
    u16 base;
    u16 page = selectror / items;
    selectror %= items;
    Fat16Record *rec = &dir.records[page * items];
    u16 item_idx = page * items;

    for (i = 0; i < items && item_idx < dir.size; i++) {

        //VDP_fillTileRect(APLAN, 0, 0, y, 40, 1);
        base = 0;
        if (selectror != i) {
            base = TILE_ATTR(1, 0, 0, 0);
        }
        STR_intToDecStringMin(item_idx++, str_buff, 3);
        VDP_drawText(APLAN, str_buff, base, x, y);

        //VDP_drawText(APLAN, rec[i].name, base, x + 4, y);
        //VDP_drawText(APLAN, rec[i].long_name, base, x + 4, y);
        if (rec[i].long_name[0] == 0) {
            VDP_drawText(APLAN, rec[i].name, base, x + 4, y);
        } else {
            VDP_drawText(APLAN, rec[i].long_name, base, x + 4, y);
        }

        if ((rec[i].flags & FAT16_TYPE_DIR)) {
            VDP_drawText(APLAN, "SUB DIR", base, x + 31, y);
        } else {
            drawNum("", rec[i].size, base, x + 31, y);
        }


        y++;
    }

}

void mmcOff() {

    u16 i = 0;

    for (i = 0; i < 65535; i++)asm("nop");
    mmcCmd(0x40, 0);
    for (i = 0; i < 65535; i++)asm("nop");
    mmcCmd(0x40, 0);
    for (i = 0; i < 65535; i++)asm("nop");


}

void viweMem(u32 addr) {

    u8 len = 24;
    u16 key_friz = 0;

    VDP_fillTileRect(APLAN, 0, 0, 0, 40, 28);
    VDP_fillTileRect(BPLAN, 0, 0, 0, 40, 28);
    VDP_fillTileRect(BPLAN, 2, 0, 27, 40, 1);
    VDP_drawTextAnc(APLAN, "(up/down)select page, (B)back", 0, 20, 27, CENTER);

    //RAM_ON;
    for (;;) {

        drawMem(addr, len);
        while (joy != 0 && key_friz < 50) {
            VDP_waitVSync();
            key_friz++;
        };
        while (joy != 0) {
            VDP_waitVSync();
            key_friz++;
            if (key_friz % 4 != 0)continue;
            break;
        }
        while (joy == 0)key_friz = 0;


        if ((joy & BUTTON_UP))addr -= len * 8;
        if ((joy & BUTTON_DOWN))addr += len * 8;
        if ((joy & BUTTON_B))return;
    }
    
}

void drawMem(u32 mem, u16 len) {

    u8 i;
    u8 y = 0;
    u8 x = 0;
    u16 val;

    while (len--) {

        x = 0;
        str_buff[x++] = ':';
        STR_intToHexStringMin(mem, &str_buff[x], 6);
        x += 6;

        str_buff[x++] = ':';
        for (i = 0; i < 4; i++) {

            STR_intToHexStringMin(*((volatile u16 *) mem), &str_buff[x], 4);
            mem += 2;
            x += 4;
            str_buff[x++] = 0x20;

        }
        mem -= 8;
        str_buff[x - 1] = ':';



        for (i = 0; i < 4; i++) {

            val = *((volatile u16 *) mem);
            mem += 2;
            str_buff[x++] = val >> 8 & 0xff;
            str_buff[x++] = val & 0xff;

        }
        str_buff[x++] = ':';
        for (i = 0; i < x; i++)if (str_buff[i] == 0)str_buff[i] = 0x20;
        str_buff[x] = 0;

        VDP_drawText(APLAN, str_buff, 0, 1, y++);
        if (y > 27)return;
    }

}

u8 getRomRegion() {

    //u8 i = 0;
    volatile u8 *region_mark = (u8 *) 0x4001f0;
    u8 u = 0;
    u8 e = 0;

    //u8 data;

    if (*region_mark == 'U' || *region_mark == 'F' || *region_mark == 'W' || *region_mark == '4')u = 1;
    if (*region_mark == 'E' || *region_mark == 'J' || *region_mark == '8')e = 1;
    /*
    while (*region_mark != 0x20 && i++ < 4) {

        data = *region_mark++;
        if (data == 'U' || data == 'F' || data == 'W' || data == '4')u = 1;
        if (data == 'E' || data == 'J' || data == '8')e = 1;
    }
     */
    if (e && !u)return REGION_PAL;
    if (!e && u)return REGION_NTSC;
    return REGION_MULTI;
}
