


#include "prog_game_.h"
#include "globals_.h"
#include "lib/vdp.h"
#include "tools_.h"
#include "eeprom_.h"
#include "hard_.h"
//#include "options_.h"

/*
#define ROM_TYPE_SMD 0
#define ROM_TYPE_SMS 1
 */
u8 progGame(Fat16Record *rec, u32 base_rom_addr, u32 file_offset, u32 file_len, u8 detect_smsm_mode) {

    u8 sms_mode;
    //u32 rom_mase = 0x400000
    //volatile u32 *rom_size = (u32 *) 0x4001a4;
    //volatile u16 *ram_mark = (u16 *) 0x4001b0;
    u8 resp;
    u16 redraw_strobe = 0;
    u32 progress_devisor;
    u32 bytcount = 0;
    u8 timescale = GET_CONSOGE_REGION == REGION_PAL ? 50 : 60;
    cy = 1;
    VDP_fillTileRect(APLAN, 0, 0, 0, 40, 28);
    VDP_fillTileRect(BPLAN, 0, 0, 0, 40, 28);
    u32 addr;


    fat16OpenFile(rec, &file);
    fat16ReadNextSector(&file);

    u32 *sega_mark = (u32 *)&(file.sectror_buff[256]);
    if (*sega_mark != 0x53454741 && detect_smsm_mode) {
        sms_mode = 1;
    } else {
        sms_mode = 0;
    }
    if (file_len == 0)file_len = file.record->size;
    fat16OpenFile(rec, &file);
    progress_devisor = file_len / 38;
    drawNum("file size: ", file_len, 0, 1, cy++);
    /*
    if (sms_mode) {
        VDP_drawText(APLAN, "ROM type: SMS", 0, 1, cy++);
    } else {
        VDP_drawText(APLAN, "ROM type: SMD", 0, 1, cy++);
    }
*/

    if (file_len + file_offset > file.record->size) {
        VDP_drawText(APLAN, "ERROR: offset + led more than file size", 0, 1, cy++);
        while (joy != 0);
        while (joy == 0);
        return 1;
    }

    if (file_len > 0x400000) {
        VDP_drawText(APLAN, "ERROR: file to big", 0, 1, cy++);
        while (joy != 0);
        while (joy == 0);
        return 1;
    }

    VDP_drawText(APLAN, "erase...", 0, 1, cy++);
    timer = 0;
    if (sms_mode) {
        eprEraseBlocks(file_len * 2, base_rom_addr);
    } else {
        eprEraseBlocks(file_len, base_rom_addr);
    }
    timer /= timescale;
    drawNum("erase time: ", timer, 0, 1, cy++);
    

    VDP_drawText(APLAN, "start wr...", 0, 1, cy++);
    timer = 0;
    VDP_fillTileRect(BPLAN, 2, 1, cy, 38, 1);

    while (file_offset) {
        resp = fat16SetNextReadSector(&file, &addr);
        if (resp != 0) {
            drawNum("ERROR SKP: ", resp, 0, 1, cy++);
            while (joy != 0);
            while (joy == 0);
            return 1;
        }
        file_offset -= 512;
    }

    while (file_len) {


        resp = fat16SetNextReadSector(&file, &addr);

        if (resp != 0) {
            cy += 3;
            drawNum("ERROR WR1: ", resp, 0, 1, cy++);
            while (joy != 0);
            while (joy == 0);
            return 1;
        }

        if (sms_mode) {
            resp = eprProgBlockSMS(addr, base_rom_addr);
            base_rom_addr += 1024;
        } else {
            resp = eprProgBlockSMD(addr, base_rom_addr);
            base_rom_addr += 512;
        }

        if (resp != 0) {
            cy += 3;
            drawNum("ERROR WR2: ", resp, 0, 1, cy++);
            while (joy != 0);
            while (joy == 0);
            return 1;
        }

        bytcount += 512;
        if (!redraw_strobe) {
            VDP_drawText(APLAN, "            ", 0, 1, cy + 1);
            drawNum("pos: ", file.pos, 0, 1, cy + 1);

            drawNum("time: ", timer / timescale, 0, 1, cy + 2);
            VDP_fillTileRect(BPLAN, 3, 1, cy, bytcount / progress_devisor, 1);
        }

        redraw_strobe += 512;
        if (file_len < 512) {
            file_len = 0;
        } else {
            file_len -= 512;
        }

    }

    VDP_drawText(APLAN, "            ", 0, 1, cy + 1);
    drawNum("len: ", file.pos, 0, 1, cy + 1);
    drawNum("time: ", timer / timescale, 0, 1, cy + 2);
    VDP_fillTileRect(BPLAN, 3, 1, cy, 38, 1);

    cy += 3;
    //VDP_drawText(APLAN, "reset bypass...", 0, 1, cy++);
    //eprResetBypass();
/*
    if (*ram_mark == 0x5241) {
        VDP_drawText(APLAN, "SRAM usage: detected!", 0, 1, cy++);
    } else {
        VDP_drawText(APLAN, "SRAM usage: not detected", 0, 1, cy++);
    }
*/
    VDP_drawText(APLAN, "done", 0, 1, cy++);
    VDP_drawText(APLAN, "press any key", 0, 1, cy++);
    //CFGC(_VBL_CATCH);
    while (joy != 0);
    while (joy == 0);
    VDP_fillTileRect(APLAN, 0, 0, 0, 40, 28);
    VDP_fillTileRect(BPLAN, 0, 0, 0, 40, 28);

    return 0;
}
