
#include "lib/types.h"
#include "lib/vdp.h"
#include "tools_.h"
#include "hard_.h"
#include "eeprom_.h"
#include "mmc_.h"



u32 epr_addr;
//u32 epr_data_buff;

u8 eprProgBlockSMD(u32 mmc_addr, u32 rom_addr) {


    u16 i = 0;
    epr_addr = rom_addr;

    if (mmcCmd(0x51, mmc_addr) != 0) {
        SS_ON;
        for (;;) {

            SPI_PORT = 0xFF;
            SPI_BUSY;
            if ((SPI_PORT & 0xff) == 0)break;
            if (i++ == 65535) {
                SS_OFF;
                VDP_drawText(APLAN, "err1", 0, 1, 26);
                return 1;
            }
        }
    }

    SS_ON;

    i = 0;
    for (;;) {
        SPI_PORT = 0xFF;
        SPI_BUSY;
        if ((SPI_PORT & 0xff) == 0xfe)break;
        if (i++ == 65535) {
            SS_OFF;
            return 2;
        }
    }

    SPI16_ON;


    asm("movem.l %d0-%d5/%a0-%a3, -(%sp)");
    asm("move.l epr_addr, %a0");
    asm("move.w #256, %d0");
    asm("move.w #1, %d3");
    asm("move.w #0x50, %d4");
    asm("move.l #0xA13000, %a1");
    asm("move.l #0xA13002, %a2");
    asm("move.l #0xaaa, %a3");

    asm("wr_loop2:");

    asm("move.w #0xffff, (%a1)");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("move.w (%a1), %d2");
    asm("move.w #0xffff, (%a1)");

    asm("wait_ry:");
    asm("move.w (%a2), %d1");
    asm("btst %d3, %d1");
    asm("beq.s  wait_ry");

    asm("move.w %d4, (%a3)"); //send epr wr cmd

    asm("move.w %d2, (%a0)+"); //write word1
    asm("move.w (%a1), (%a0)+"); //write word2


    asm("subq.w  #2, %d0");
    asm("bne.s  wr_loop2");

    asm("movem.l (%sp)+, %d0-%d5/%a0-%a3");

    SPI16_OFF;


    //epr_addr += 512;

    SPI_BUSY;
    SPI_PORT = 0xFF;
    SPI_BUSY;
    SPI_PORT = 0xFF;
    SS_OFF;

    return 0;
}

u8 eprProgBlockSMS(u32 mmc_addr, u32 rom_addr) {


    u16 i = 0;
    //u16 data;
    //volatile u16 *rom;
    epr_addr = rom_addr;

    if (mmcCmd(0x51, mmc_addr) != 0) {
        SS_ON;
        for (;;) {

            SPI_PORT = 0xFF;
            SPI_BUSY;
            //asm("nop");
            //asm("nop");
            if ((SPI_PORT & 0xff) == 0)break;
            if (i++ == 65535) {
                SS_OFF;
                VDP_drawText(APLAN, "err1", 0, 1, 26);
                return 1;
            }
        }
    }

    SS_ON;

    i = 0;
    for (;;) {
        SPI_PORT = 0xFF;
        SPI_BUSY;
        if ((SPI_PORT & 0xff) == 0xfe)break;
        if (i++ == 65535) {
            SS_OFF;
            return 2;
        }
    }

    //SPI16_ON;

    asm("movem.l %d0-%d4/%a0-%a3, -(%sp)");
    asm("move.l epr_addr, %a0");
    asm("move.w #256, %d0");
    asm("move.w #1, %d3");
    asm("move.w #0x50, %d4");
    asm("move.l #0xA13000, %a1");
    asm("move.l #0xA13002, %a2");
    asm("move.l #0xaaa, %a3");

    asm("wr_loop22:");

    asm("move.w #0xffff, (%a1)");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("move.w (%a1), %d2");
    asm("move.w #0xffff, (%a1)");

    asm("wait_ry22:");
    asm("move.w (%a2), %d1");
    asm("btst %d3, %d1");
    asm("beq.s  wait_ry22");

    asm("move.w %d4, (%a3)");

    asm("move.w %d2, (%a0)+");
    asm("move.w (%a1), (%a0)+");


    asm("subq.w  #1, %d0");
    asm("bne.s  wr_loop22");

    asm("movem.l (%sp)+, %d0-%d4/%a0-%a3");

    //SPI16_OFF;

    //epr_addr += 1024;

    SPI_BUSY;
    SPI_PORT = 0xFF;
    SPI_BUSY;
    SPI_PORT = 0xFF;
    SS_OFF;
    return 0;
}

void eprProgBlock(u16 *data, u32 rom_addr, u32 len) {

    u32 i;
    volatile u16 *addr = (u16 *) rom_addr;
    len >>= 2;

    for (i = 0; i < len; i++) {

        EPR_BUSY;
        *addr = 0x50;
        *((volatile u16 *)0xaaa) = 0x50;
        *addr++ = *data++;
        *addr++ = *data++;
    }

    EPR_BUSY;
}

void eprUnlockBypass() {

    EPR_BUSY;
    EPR_CMD(0x555, 0xaa);
    EPR_CMD(0x2aa, 0x55);
    EPR_CMD(0x555, 0x20);
    EPR_BUSY;


}

void eprResetBypass() {

    EPR_BUSY;
    EPR_CMD(0, 0x90);
    EPR_CMD(0, 0);
    EPR_BUSY;


}

u32 len_bf;
u32 base_addr_bf;

void eprEraseBlocks(u32 len, u32 base_addr) {

    //u32 i;
    //VBL_PORT = 0x0030;
    base_addr_bf = base_addr;
    if (len % 65536 != 0)len += 65536 - len % 65536;
    len_bf = len;
    len_bf /= 65536;


    EPR_BUSY;
    EPR_CMD(0x555, 0xaa);
    EPR_CMD(0x2aa, 0x55);
    EPR_CMD(0x555, 0x80);
    EPR_CMD(0x555, 0xaa);
    EPR_CMD(0x2aa, 0x55);



    asm("movem.l %d0/%a0, -(%sp)");
    asm("move.l base_addr_bf, %a0");
    asm("move.l len_bf, %d0");

    asm("erase:");
    asm("move.w #0x30, (%a0)");
    asm("add.l #65536, %a0");
    asm("subq.w  #1, %d0");
    asm("bne.s  erase");

    asm("movem.l (%sp)+, %d0/%a0");


    //VBL_PORT = 0x0020;
    EPR_BUSY;
/*
    if (base_addr == 0 && device_info.region1_blocks == 8) {
        VDP_drawText(APLAN, "special erase a", TILE_ATTR(1, 0, 0, 0), 1, 25);
        VBL_PORT = 0x0030;
        EPR_CMD(0x555, 0xaa);
        EPR_CMD(0x2aa, 0x55);
        EPR_CMD(0x555, 0x80);
        EPR_CMD(0x555, 0xaa);
        EPR_CMD(0x2aa, 0x55);
        for (i = 0; i < 65536;) {
            EPR_CMD(i, 0x30);
            i += 8192;
        }
        VBL_PORT = 0x0020;
    }
    EPR_BUSY;
    if (base_addr + len == device_info.mem_size && device_info.region2_blocks == 8) {
        VDP_drawText(APLAN, "special erase b", TILE_ATTR(1, 0, 0, 0), 1, 25);
        VBL_PORT = 0x0030;
        EPR_CMD(0x555, 0xaa);
        EPR_CMD(0x2aa, 0x55);
        EPR_CMD(0x555, 0x80);
        EPR_CMD(0x555, 0xaa);
        EPR_CMD(0x2aa, 0x55);
        for (i = device_info.mem_size - 65536; i < device_info.mem_size;) {
            EPR_CMD(i, 0x30);
            i += 8192;
        }
        VBL_PORT = 0x0020;
    }
    EPR_BUSY;
*/
}

void eprEraseChip() {


    EPR_BUSY;

    EPR_CMD(0x555, 0xaa);
    EPR_CMD(0x2aa, 0x55);
    EPR_CMD(0x555, 0x80);
    EPR_CMD(0x555, 0xaa);
    EPR_CMD(0x2aa, 0x55);
    EPR_CMD(0x555, 0x10);

    EPR_BUSY;


}

void eprWrBios(u32 addr, u16 data) {

    EPR_BUSY;
    *((volatile u16*) (0x555 << 1)) = 0xaa;
    *((volatile u16*) (0x2aa << 1)) = 0x55;
    *((volatile u16*) (0x555 << 1)) = 0xa0;
    *((volatile u16*) addr) = data;
    EPR_BUSY;


}
