.text
.org 0
jmp main

.org 0x08
rts

.org 0x10
rts

.org 0x18
rts

.org 0x20
rte

.org 0x30
rte

.org 0x40
rte

.org 0x50
.incbin "icon.bin"
.org 0xD0
.incbin "icon-pal.bin"
.org 0xF0
.ascii	"link app player"
.org 0x100
jmp main

.equ CMD_NEW, '*'
.equ CMD_OK, 'k'
.equ CMD_TEST, 't'
.equ CMD_WRITE_DWORDS, 'S'
.equ CMD_JMP_TO_RAM_APP, 'j'
.equ CMD_SET_ADDR, 'a'


*((volatile u8*) PORT_CTRL) = 0;                             \
    *((volatile u8*) PORT_DATA) = (1 << RD) | (1 << WR);         \
    *((volatile u8*) PORT_CTRL) = (1 << RD) | (1 << WR);

*app address must be set on a0

main:
    move.l #0, %sp
    bsr fifo_init
main_loop:

    bsr fifo_read
    cmp.b #CMD_NEW, %d0
    bne main_loop

    bsr fifo_read
    
    cmp.b #CMD_JMP_TO_RAM_APP, %d0
    beq cmd_jump_to_ram_app

    cmp.b #CMD_TEST, %d0
    beq cmd_test

    cmp.b #CMD_SET_ADDR, %d0
    beq set_addr

    cmp.b #CMD_WRITE_DWORDS, %d0
    beq cmd_write32

    jmp main_loop

cmd_test:
    move.b #CMD_OK, %d0
    bsr fifo_write
    jmp main_loop

cmd_jump_to_ram_app:
    move.l #0xff0000, %a0
    jmp 0xff0000

set_addr:
    lsl.l   #8, %d0
    bsr fifo_read
    lsl.l   #8, %d0
    bsr fifo_read
    lsl.l   #8, %d0
    bsr fifo_read
    lsl.l   #8, %d0
    bsr fifo_read
    move.l %d0, %a0
    jmp main_loop


cmd_write32:

    bsr mem_write32
    move.b #CMD_OK, %d0
    bsr fifo_write
    jmp main_loop
