

.equ PORT_DATA, 0xA10005
.equ PORT_CTRL, 0xA1000b
.equ RD, 6
.equ WR, 5
.equ RXF, 4

*a0 addr
*d0 write read data
*d1 temp
*d2 counter

.global fifo_init
fifo_init:
    move.b #0, PORT_CTRL
    move.b #0, PORT_DATA
    bset.b #RD, PORT_DATA
    bset.b #WR, PORT_DATA
    bset.b #RD, PORT_CTRL
    bset.b #WR, PORT_CTRL
    rts

                      
.global fifo_write
fifo_write:

    or.b #15, PORT_CTRL

    move.b %d0, %d1
    lsr.b #4, %d1
    and.b #15, %d1
    bset.b #RD, %d1
    move.b %d1, PORT_DATA
    bset.b #WR, PORT_DATA

    move.b %d0, %d1
    and.b #15, %d1
    bset.b #RD, %d1
    move.b %d1, PORT_DATA
    bset.b #WR, PORT_DATA
    
    and.b #240, PORT_CTRL
    rts

.global fifo_read
fifo_read:

b1:
    btst.b  #RXF, PORT_DATA
    bne.s   b1
    bclr    #RD, PORT_DATA
b2:
    btst.b  #RXF, PORT_DATA
    beq.s   b2
    move.b  PORT_DATA, %d0
    lsl.b   #4, %d0
    bset    #RD, PORT_DATA
b3:
    btst.b  #RXF, PORT_DATA
    bne.s   b3
    bclr    #RD, PORT_DATA
b4:
    btst.b  #RXF, PORT_DATA
    beq.s   b4
    move.b  PORT_DATA, %d1
    and.b   #15, %d1
    or.b    %d1, %d0
    bset    #RD, PORT_DATA
    rts


.globl mem_write32
mem_write32:

    move.l  #0, %d2
    bsr     fifo_read
    move.b  %d0, %d2
    lsl.w   #8, %d2
    bsr     fifo_read
    move.b  %d0, %d2

loop:

    bsr     fifo_read
    lsl.w   #8, %d0

    bsr     fifo_read
    lsl.l   #8, %d0

    bsr     fifo_read
    lsl.l   #8, %d0

    bsr     fifo_read

    move.l %d0, (%a0)+

    bsr     fifo_read
    lsl.w   #8, %d0

    bsr     fifo_read
    lsl.l   #8, %d0

    bsr     fifo_read
    lsl.l   #8, %d0

    bsr     fifo_read

    move.l %d0, (%a0)+

    subq.w #2, %d2
    bne.s loop

    rts


