/*
 * File:   main.c
 * Author: krikzz
 *
 * Created on 23.06.2010
 */



#include "../../lib/segalib.h"
#include "../../lib/everdrive.h"
#include "../../lib/fat16.h"


u8 sector_buff[512];

//you sould keep only one static dir struct because dir struct need a lot of ram
Fat16Dir dir;
Fat16File file;
volatile u16 joy;

u8 selectFile();

int main() {

    u16 i;
    u8 result = 0;
    u8 cy = 2;
    u8 file_idx = 0;

    VDP_init();
    JOY_init();
    VDP_loadFont(font_base, 0);
    VDP_setPaletteColor(0, 15, 0xfff); //font color
    VDP_setPaletteColor(1, 15, 0x888); //font color


    evd_init(1, 0);


    //fat initialization
    result = fat16Init();
    if (result != 0) {
        VDP_drawText(APLAN, "error 1", 0, 3, cy++);
        for (;;);
    }

    //open root dir
    result = fat16OpenDir(0, &dir);
    if (result != 0) {
        VDP_drawText(APLAN, "error 2", 0, 3, cy++);
        for (;;);
    }

    //now we should select file
    file_idx = selectFile();

    //now we can open selected file
    result = fat16OpenFile(&dir.records[file_idx], &file);
    if (result != 0) {
        VDP_drawText(APLAN, "error 3", 0, 3, cy++);
        for (;;);
    }

    //read first sector of selected file
    result = fat16ReadNextSector(&file);

    if (result != 0) {
        VDP_drawText(APLAN, "error 4", 0, 3, cy++);
        for (;;);
    }


    VDP_fillTileRect(APLAN, 0, 0, 0, 40, 28); //clean screen
    //print sector data
    for (i = 0; i < 512; i++) {
        VDP_setTile(APLAN, file.sectror_buff[i] - 32 + TILE_FONTINDEX, i % 40, i / 40);
    }


    for (;;);

    return 0;
}

u8 selectFile() {

    u16 i;
    u8 selector = 0;

    for (;;) {

        for (i = 0; i < 20 && i < dir.size; i++) {
            if (selector == i) {
                VDP_drawText(APLAN, dir.records[i].long_name, TILE_ATTR(0, 0, 0, 0), 3, i + 3);
            } else {
                VDP_drawText(APLAN, dir.records[i].long_name, TILE_ATTR(1, 0, 0, 0), 3, i + 3);
            }
        }

        while (joy != 0);
        while (joy == 0);

        if ((joy & BUTTON_UP)) {

            if (selector > 0)selector--;

        }
        if ((joy & BUTTON_DOWN)) {
            selector++;
            if (selector >= dir.size || selector >= 20)selector = dir.size > 20 ? 19 : dir.size - 1;
        }


        if ((joy & BUTTON_START) && (dir.records[selector].flags & FAT16_TYPE_FILE)) {
            return selector;
        }


    }

}

void vb() {
    //vblank interrupt
    joy = JOY_readJoypad(JOY_1);
}

void hb() {
    //hblank interrupt
}

void in() {
    //all other interrupts
}
