
#include "genesis.h"
#include "menu.h"
#include "map.h"
#include "resmap.h"
#include "sprite.h"
#include "map_editor.h"
#include "gameover.h"
#include "game.h"
//#include "audio.h"

void joyEvent(u16 joy, u16 changed, u16 state);

s8 selector;
s8 selected_item;

void startMenu() {

    selected_item = -1;
    u16 scroll = 0;
    if (!map_editor_map_ready) {
        selector = 0;
        scroll = -224;
    }
    u16 joy1;
    u32 now_top = game_player[0].scor > game_player[1].scor ? game_player[0].scor : game_player[1].scor;


    VDP_setPalette(0, palette_black);
    VDP_resetSprites();
    VDP_updateSpritesDma();

    VDP_fillTileRect(APLAN, 0, 0, 0, vdp_plan_w, vdp_plan_h);
    setMap(APLAN, maps_data, 0);
    drawNum(top_scor, 136 / 8, 1);
    drawNum(now_top, 56 / 8, 1);
    VDP_setVerticalScroll(APLAN, 0, scroll);
    sleepFrames(1);
    VDP_setPalette(0, pal_menu);
    VDP_setPalette(1, pal_yellow);
    _tank tank;
    tank.color = TANK_COLOR_RED;
    tank.posx = SPRITE_POS_SELECTOR_X;
    tank.posy = SPRITE_POS_SELECTOR_Y;
    tank.rotate = 3;
    tank.type = 0;
    tank.color = TANK_COLOR_YELLOW;
    tank.hitpoint = 1;
    tank.god = 0;
    tank.birth = 0;
    tank.speed = 1;
    tank.freeze = 0;
    tank.bonus = 0;





    while (scroll++) {

        VDP_setVerticalScroll(APLAN, 0, scroll);
        VDP_waitVSync();
        joy1 = JOY_readJoypad(JOY_1);
        if (joy1 & BUTTON_START) break;
    }
    VDP_setVerticalScroll(APLAN, 0, 0);
    JOY_setEventHandler(joyEvent);


    for (;;) {

        tank.posy = SPRITE_POS_SELECTOR_Y + (selector << 4);
        drawTank(&tank);
        updateSprite();
        VDP_waitVSync();
        if (selected_item >= 0)break;
    }

    JOY_setEventHandler(0);
    
}

s8 menuGetSelectedItem() {

    return selected_item;
}

void joyEvent(u16 joy, u16 changed, u16 state) {

    if (BUTTON_UP & state) {
        selector--;
        if (selector < 0)selector = 2;
    }
    if (BUTTON_DOWN & state) {
        selector++;
        if (selector > 2)selector = 0;
    }
    if (BUTTON_START & state) {
        selected_item = selector;
    }
}
