#ifndef _Z80_CTRL_H_
#define _Z80_CTRL_H_


#define Z80_HALT_PORT                   0xA11100
#define Z80_RESET_PORT                  0xA11200

#define Z80_RAM                         0xA00000
#define Z80_YM2612                      0xA04000
#define Z80_BANK_REGISTER               0xA06000

#define Z80_DRIVER_NULL                 0
// variable rate sample player Z80 driver
// it can play a sample (8 bit unsigned) from 4 Khz up to 52 Khz rate
#define Z80_DRIVER_SAMPLEPLAY           1
// 2 channels sample player Z80 driver
// it can mix 2 samples (8 bit signed) at a fixed 13 Khz rate.
#define Z80_DRIVER_2SAMPLESPLAY         2
// MVS tracker Z80 driver
#define Z80_DRIVER_MVSTRACKER           3
#define Z80_DRIVER_SHIRU				4

#define Z80_DRIVER_DEFAULT              Z80_DRIVER_SAMPLEPLAY


void Z80_init();

u16  Z80_isBusTaken();
void Z80_requestBus(u16 wait);
void Z80_releaseBus();

void Z80_startReset();
void Z80_endReset();

void Z80_setBank(const u16 bank);



void Z80_uploadData(const u16 dest, const u8 *data, const u16 size, const u16 resetz80);
const u8* Z80_getLoadedDriver();
void Z80_loadDriver(const u8 *drv, u16 len, const u16 waitReady);


#endif // _Z80_CTRL_H_
