#include "types.h"

#include "vdp.h"
#include "vdp_tile.h"

#include "tools.h"
#include "vdp_dma.h"


// ~76 bytes per scanline in software (during blanking)
// ~190 bytes per scanline in hardware (during blanking)

void VDP_loadTileTo(const u32 *data, u16 index, u16 num, u8 use_dma) {
    u16 addr;

    addr = index << 5;
    if (use_dma) VDP_DoVRamDMA((u32) data, addr, num << 5);
    else {

        const u32 *src;
        u16 i;

        VDP_setAutoInc(2);

        /* point to vdp port */

        *vdp_ctrl_port_ptr32 = GFX_WRITE_VRAM_ADDR(addr);

        src = data;

        i = num;
        while (i--) {
            *vdp_data_port_ptr32 = *src++;
            *vdp_data_port_ptr32 = *src++;
            *vdp_data_port_ptr32 = *src++;
            *vdp_data_port_ptr32 = *src++;
            *vdp_data_port_ptr32 = *src++;
            *vdp_data_port_ptr32 = *src++;
            *vdp_data_port_ptr32 = *src++;
            *vdp_data_port_ptr32 = *src++;
        }
    }
}

void VDP_loadFont(const u32 *font, u8 use_dma) {
    VDP_loadTileTo(font, TILE_FONTINDEX, 128, use_dma);
}

void VDP_setTile(u16 plan, u16 tile, u16 x, u16 y) {
    /*
        volatile u32 *plctrl;
        volatile u16 *pwdata;
     */
    u32 addr;

    addr = plan + ((x + (vdp_plan_w * y)) << 1);

    /* point to vdp port */


    *vdp_ctrl_port_ptr32 = GFX_WRITE_VRAM_ADDR(addr);
    *vdp_data_port_ptr16 = tile;
}

void VDP_fillTileRect(u16 plan, u16 tile, u16 x, u16 y, u16 w, u16 h) {
    /*
        volatile u32 *plctrl;
        volatile u16 *pwdata;
     */
    u32 addr;
    u32 planwidth;
    u16 i, j;

    VDP_setAutoInc(2);

    /* point to vdp port */

    planwidth = vdp_plan_w;
    addr = plan + ((x + (planwidth * y)) << 1);

    i = h;
    while (i--) {
        *vdp_ctrl_port_ptr32 = GFX_WRITE_VRAM_ADDR(addr);

        j = w;
        while (j--) *vdp_data_port_ptr16 = tile;

        addr += planwidth << 1;
    }
}

void VDP_fillTileRectInc(u16 plan, u16 basetile, u16 x, u16 y, u16 w, u16 h) {

    /*
        volatile u32 *plctrl;
        volatile u16 *pwdata;
     */
    u32 addr;
    u32 planwidth;
    u16 tile;
    u16 i, j;

    VDP_setAutoInc(2);

    /* point to vdp port */

    planwidth = vdp_plan_w;
    addr = plan + ((x + (planwidth * y)) << 1);
    tile = basetile;

    i = h;
    while (i--) {
        *vdp_ctrl_port_ptr32 = GFX_WRITE_VRAM_ADDR(addr);

        j = w;
        while (j--) *vdp_data_port_ptr16 = tile++;

        addr += planwidth << 1;
    }
}

void VDP_setTileRect(u16 plan, const u16 *data, u16 basetile, u16 x, u16 y, u16 w, u16 h) {


    /*
        volatile u32 *plctrl;
        volatile u16 *pwdata;
     */
    const u16 *src;
    u32 addr;
    u32 planwidth;
    u16 i, j;

    VDP_setAutoInc(2);

    /* point to vdp port */


    planwidth = vdp_plan_w;
    addr = plan + ((x + (planwidth * y)) << 1);
    src = data;

    i = h;
    while (i--) {
        *vdp_ctrl_port_ptr32 = GFX_WRITE_VRAM_ADDR(addr);

        j = w;
        while (j--) *vdp_data_port_ptr16 = basetile | *src++;

        addr += planwidth << 1;
    }
}

void VDP_drawText(u16 plan, const char *str, u16 basetile, u16 x, u16 y) {
    u32 len;
    u16 data[40];
    u16 i;

    // get the horizontal plan size (in cell)
    i = vdp_plan_w;
    len = strlen(str);

    // if string don't fit in plan, we cut it
    if (len > (i - x)) len = i - x;

    for (i = 0; i < len; i++) data[i] = TILE_FONTINDEX + (str[i] - 32);
    VDP_setTileRect(plan, data, basetile, x, y, len, 1);
}

void VDP_setTileRectDma(u16 plan, const u16 *data, u16 x, u16 y, u16 w, u16 h) {

    u16 i;
    plan += ((x + vdp_plan_w * y) << 1);
    w <<= 1;
    for (i = 0; i < h; i++) {

        VDP_DoDMA(VDP_DMA_VRAM, (u32) data, plan, w);
        plan += vdp_plan_w << 1;
        data += w >> 1;
    }
}
