#include "types.h"


#include "vdp.h"
#include "vdp_dma.h"

#include "z80_ctrl.h"

void VDP_DoDMA(u8 area, u32 from, u16 to, u16 len) {


    VDP_setAutoInc(2);


    /* Setup DMA length (in word here) */
    len >>= 1;
    *vdp_ctrl_port_ptr16 = 0x9300 + (len & 0xff);
    len >>= 8;
    *vdp_ctrl_port_ptr16 = 0x9400 + (len & 0xff);

    /* Setup DMA address */
    from >>= 1;
    *vdp_ctrl_port_ptr16 = 0x9500 + (from & 0xff);
    from >>= 8;
    *vdp_ctrl_port_ptr16 = 0x9600 + (from & 0xff);
    from >>= 8;
    *vdp_ctrl_port_ptr16 = 0x9700 + (from & 0xff);

    /* Halt the Z80 for DMA */
    //    Z80_RequestBus(0);

    /* Enable DMA */

    switch (area) {
        case VDP_DMA_VRAM:
            *vdp_ctrl_port_ptr32 = GFX_DMA_VRAM_ADDR(to);
            break;

        case VDP_DMA_CRAM:
            *vdp_ctrl_port_ptr32 = GFX_DMA_CRAM_ADDR(to);
            break;

        case VDP_DMA_VSRAM:
            *vdp_ctrl_port_ptr32 = GFX_DMA_VSRAM_ADDR(to);
            break;
    }

    /* Enable Z80 */
    //    Z80_ReleaseBus();
}

void VDP_DoDMAFill(u16 to, u16 len, u16 value) {

    /* Setup DMA length */
    *vdp_ctrl_port_ptr16 = 0x9300 + (len & 0xff);
    len >>= 8;
    *vdp_ctrl_port_ptr16 = 0x9400 + (len & 0xff);

    /* Setup DMA operation (VRAM FILL) */
    *vdp_ctrl_port_ptr16 = 0x9780;

    /* Enable DMA */
    VDP_setAutoInc(1);
    *vdp_ctrl_port_ptr32 = GFX_DMA_VRAM_ADDR(to);

    /* set up value to fill */
    *vdp_data_port_ptr16 = value << 8;
}

void VDP_DoDMACopy(u8 area, u16 from, u16 to, u16 len) {



    /* Setup DMA length */
    *vdp_ctrl_port_ptr16 = 0x9300 + (len & 0xff);
    len >>= 8;
    *vdp_ctrl_port_ptr16 = 0x9400 + (len & 0xff);

    /* Setup DMA address */
    *vdp_ctrl_port_ptr16 = 0x9500 + (from & 0xff);
    *vdp_ctrl_port_ptr16 = 0x9600 + ((from >> 8) & 0xff);

    /* Setup DMA operation (VRAM COPY) */
    *vdp_ctrl_port_ptr16 = 0x97C0;

    /* Enable DMA */
    switch (area) {
        case VDP_DMA_VRAM:
            VDP_setAutoInc(1);
            *vdp_ctrl_port_ptr32 = GFX_DMA_VRAM_ADDR(to);
            break;

        case VDP_DMA_CRAM:
            VDP_setAutoInc(2);
            *vdp_ctrl_port_ptr32 = GFX_DMA_CRAM_ADDR(to);
            break;

        case VDP_DMA_VSRAM:
            VDP_setAutoInc(2);
            *vdp_ctrl_port_ptr32 = GFX_DMA_VSRAM_ADDR(to);
            break;
    }
}
