#include "types.h"

#include "base.h"

#include "vdp.h"
#include "vdp_pal.h"
#include "psg.h"
#include "ym2612.h"
#include "joy.h"
#include "z80_ctrl.h"
#include "bitmap.h"
#include "logo_lib.h"
#include "timer.h"
#define nologo_

// we don't want to share them
extern u16 randbase;
extern _joyEventCallback *joyEventCB;

// extern library callback function (we don't want to share them)
extern u16 VDP_doStepFading();

// main function
extern int main();


static _voidCallback *VBlankCB;
static _voidCallback *HBlankCB;

u32 VBlankProcess;
u32 HBlankProcess;


// VBlank Callback

void _vblankcallback() {

    // joy state refresh
    JOY_update();

    // specials VBlank processing
    /*
    if (VBlankProcess)
    {
        // palette fading
        if (VBlankProcess & PROCESS_PALETTE_FADING)
        {
            if (!VDP_doStepFading()) VBlankProcess &= ~PROCESS_PALETTE_FADING;
        }

        // ...
    }

    // then call user's callback
    
     * */
    if (VBlankCB) VBlankCB();
}

// HBlank Callback

void _hblankcallback() {
    // specials HBlank processing
    if (HBlankProcess) {
        // ...
    }

    // then call user's callback
    if (HBlankCB) HBlankCB();
}

void start() {
    // initiate random number generator
    randbase = 0xD94B;

    VBlankCB = 0;
    HBlankCB = 0;
    VBlankProcess = 0;
    HBlankProcess = 0;

    // init part
    JOY_init();
    VDP_init();

    
    // reseting z80 also reset the ym2612


    // let's the fun go on !
    main();
}

void setVBlankCallback(_voidCallback *CB) {
    VBlankCB = CB;
}

void setHBlankCallback(_voidCallback *CB) {
    HBlankCB = CB;
}

