
#include "genesis.h"
#include "audio.h"
#include "z80drv.h"

s16 curr_priority;

void startPlaySample(const u8 *sample, const u32 len, const u16 rate, const u8 pan, u8 priority) {

    u8 *pb;
    u32 addr;
    u16 r;
    u16 w;

    // load the appropried driver if not already done
    if (isPlayingSample() && priority < curr_priority) {
        return;
    }
    curr_priority = priority;

    Z80_requestBus(1);

    addr = (u32) sample;

    // point to Z80 base parameters
    pb = (u8 *) 0xA00060;

    // sample address
    pb[0x00] = addr >> 0;
    pb[0x01] = addr >> 8;
    pb[0x02] = addr >> 16;

    // sample length
    pb[0x04] = len >> 0;
    pb[0x05] = len >> 8;
    pb[0x06] = len >> 16;

    // pan (left / right / center)
    pb[0x0B] = pan;

    // command
    pb[0x08] |= 1;

    if (rate > 52000) r = 52000;
    else if (rate < 500) r = 500;
    else r = rate;

    w = 3580000 / r;
    if (w > 84) {
        w = (w - 69) / 8;
        if (w & 1) w = (w >> 1) + 1;
        else w = w >> 1;
    }
    else w = 1;

    // wait
    pb[0x0A] = w;

    Z80_releaseBus();
}

void stopPlaySample() {
    u8 *pb;

    // load the appropried driver if not already done
    //Z80_loadDriver(z80drv, sizeof (z80drv), 1);

    Z80_requestBus(1);

    // point to Z80 command
    pb = (u8 *) 0xA00068;

    // command
    *pb |= 2;

    Z80_releaseBus();
}

u8 isPlayingSample() {
    u8 *pb;
    u8 ret;

    // load the appropried driver if not already done
    //Z80_loadDriver(z80drv, sizeof (z80drv), 1);

    Z80_requestBus(1);

    // point to Z80 play status
    pb = (u8 *) 0xA0007C;

    // status
    ret = *pb & 1;

    Z80_releaseBus();

    return ret;
}
