/*
 * File:   main.c
 * Author: krikzz
 *
 * Created on 23.06.2010
 */



#include "../../lib/segalib.h"
#include "../../lib/everdrive.h"


u8 sector_buff[512];

int main() {

    u16 i;
    u8 result = 0;
    u8 cy = 2;
    VDP_init();
    VDP_loadFont(font_base, 0);
    VDP_setPaletteColor(0, 15, 0xfff); //font color


    evd_init(1, 0);

    //mmc/sd initialization
    result = evd_mmcInit();
    if (result != 0) {
        VDP_drawText(APLAN, "error 1", 0, 3, cy++);
        for (;;);
    }

    //read 512 bytes form first card sector
    result = evd_mmcRdBlock(0, sector_buff);
    if (result != 0) {
        VDP_drawText(APLAN, "error 2", 0, 3, cy++);
        for (;;);
    }

    //print sector data
    for (i = 0; i < 512; i++) {
        VDP_setTile(APLAN, sector_buff[i] - 32 + TILE_FONTINDEX, i % 40, i / 40);
    }


    for (;;);

    return 0;
}

void vb() {
    //vblank interrupt
}

void hb() {
    //hblank interrupt
}

void in() {
    //all other interrupts
}
