/* 
 * File:   fifo.h
 * Author: krikzz
 *
 * Created on 20.10.2009 , 5:00
 */

//link unit should be connected to joy port 2

#define RD 0x06
#define WR 0x05
#define RXF 0x04
#define PORT_DATA 0xA10005
#define PORT_CTRL 0xA1000b

#define FIFO_WRITE(data)                                         \
{                                                                \
    *((volatile u8*) PORT_CTRL) |= 15;                           \
    *((volatile u8*) PORT_DATA) = (data >> 4) | (1 << RD);       \
    *((volatile u8*) PORT_DATA) |= (1 << WR);                    \
    *((volatile u8*) PORT_DATA) = (data & 15) | (1 << RD);       \
    *((volatile u8*) PORT_DATA) |= (1 << WR);                    \
    *((volatile u8*) PORT_CTRL) &= ~15;                          \
}

#define FIFO_READ(data)                                          \
{                                                                \
     while ((*((volatile u8*) PORT_DATA) & (1 << RXF)));         \
    *((volatile u8*) PORT_DATA) &= ~(1 << RD);                   \
    while (!(*((volatile u8*) PORT_DATA) & (1 << RXF)));         \
    data = *((volatile u8*) PORT_DATA) << 4;                     \
    *((volatile u8*) PORT_DATA) |= (1 << RD);                    \
    while ((*((volatile u8*) PORT_DATA) & (1 << RXF)));          \
    *((volatile u8*) PORT_DATA) &= ~(1 << RD);                   \
    while (!(*((volatile u8*) PORT_DATA) & (1 << RXF)));         \
    data |= *((volatile u8*) PORT_DATA) & 15;                    \
    *((volatile u8*) PORT_DATA) |= (1 << RD);                    \
}

#define FIFO_INIT                                                \
{                                                                \
    *((volatile u8*) PORT_CTRL) = 0;                             \
    *((volatile u8*) PORT_DATA) = (1 << RD) | (1 << WR);         \
    *((volatile u8*) PORT_CTRL) = (1 << RD) | (1 << WR);         \
}

#define FIFO_DISABLE                                             \
{                                                                \
    *((volatile u8*) PORT_CTRL) = 0;                             \
    *((volatile u8*) PORT_DATA) = 0;                             \
    *((volatile u8*) PORT_CTRL) = 0;                             \
}

#define DATA_AVAILABLE !(*((volatile u8*) PORT_DATA) & (1 << RXF))
