

#include "types.h"
#include "device_control.h"
#include "uart.h"
#include "cmd_code.h"
#include "defs.h"
#include "mem.h"
#include <avr/interrupt.h>

void usbMode();

void startUsbMode(){
	
	SET_PORT_STATE_USB;
	uartInit();
	usbMode();
}


void usbMode(){

	u8 cmd = 0;
	u16 addr = 0;
	u8 data = 0;
	void (*bootloader)( void ) = (void*)0x1C00;

	for(;;){
		
		LED0;
		cmd = uartRX();
		if(cmd != CMD_NEW)continue;
		LED1;
		cmd = uartRX();
		
		switch(cmd){


			case CMD_PROG_BLOCK:
				progBlock();
				uartTX(CMD_OK);
				break;
		
		
		
			case  CMD_DUMP_BLOCK:
				dumpBlock();
				break;
		
	
		
			case  CMD_TEST:
				uartTX(CMD_OK);
				break;

		
		
			case  CMD_DEVICE_ID:
				uartTX(CMD_OK);
				uartTX16(DEVICE_ID);
				break;

		
		
			case  CMD_FIRM_VERSION:
				uartTX(CMD_OK);
				uartTX16(FIRMWARE_VERSION);
				break;


		
			case  CMD_SET_ADDR:
				mem_addr = uartRX32();
				uartTX(CMD_OK);
				break;
		

		
			case  CMD_UNLOCK_BYPASS:
				unlockBypass();
				uartTX(CMD_OK);
				break;


		
			case  CMD_RESET_BYPASS:
				resetBypass();
				uartTX(CMD_OK);
				break;


		
			case  CMD_ERASE:
				eraseChip();
				uartTX(CMD_OK);
				break;
		
		

			case  CMD_READ_EEPROM:
			
				addr = uartRX();
				uartTX(CMD_OK);
				uartTX(eeprom_read_byte((u8*)addr));
				break;	
		
		
		
			case  CMD_WRITE_EEPROM:
			
				addr = uartRX();
				data = uartRX();
				eeprom_write_byte((u8*)addr, data);
				uartTX(CMD_OK);
				break;


		
			case  CMD_RESET:
				uartTX(CMD_OK);
				cli();
				sleep128;
				uartReset();
				bootloader();
				break;

			case CMD_CRC_FOR_AREA:
				uartTX(CMD_OK);
				calcCrcForArea();
				break;
		
		
			default:
			 	uartTX('U');


		 }

	}

}
