
#include <avr/io.h>
#include <avr/interrupt.h>
#include "types.h"
#include "uart.h"


u8 rx_buff[UART_RX_BUFF_SIZE];
volatile u16 rx_end;
volatile u16 rx_start;

u8 D_UCSRA;
u8 D_UBRRH;
u8 D_UBRRL;
u8 D_UCSRB;
u8 D_UCSRC;

void uartInit(){
	
	D_UCSRA = UCSRA;
	D_UBRRH = UBRRH;
	D_UBRRL = UBRRL;
	D_UCSRB = UCSRB;
	D_UCSRC = UCSRC;

	UCSRA |=(1<<U2X);
	UBRRH = (F_CPU/(UART_BAUDRATE * 8L)-1) >> 8;         //High byte of UART speed
  	UBRRL = (uint8_t)(F_CPU/(UART_BAUDRATE * 8L)-1);     //Low byte of UART speed
	UCSRB = (1 << RXEN) | (1 << TXEN) | (1 << RXCIE);
	UCSRC = (1 << URSEL) | (3 << UCSZ0);
	rx_end = 0;
	rx_start = 0;
	sei();
}

void uartReset(){
	
	UCSRA = D_UCSRA;
	UBRRH = D_UBRRH;
	UBRRL = D_UBRRL;
	UCSRB = D_UCSRB;
	UCSRC = D_UCSRC;
}

inline u8 uartRX(){
	
	if(rx_start == UART_RX_BUFF_SIZE)rx_start = 0;

	while(rx_end == rx_start){

	}
	
	return rx_buff[rx_start++];
	
}

inline u16 uartRX16(){
	
	u16 data;

	if(rx_start == UART_RX_BUFF_SIZE)rx_start = 0;

	while(rx_end == rx_start){
	}

	data = rx_buff[rx_start++] << 8;

	if(rx_start == UART_RX_BUFF_SIZE)rx_start = 0;

	while(rx_end == rx_start){
	}

	data |= rx_buff[rx_start++];
	
	return data;
	
}

inline u32 uartRX32(){
	
	u32 data;

	if(rx_start == UART_RX_BUFF_SIZE)rx_start = 0;

	while(rx_end == rx_start){
	}

	data = (u32)(rx_buff[rx_start++]) << 24;

	if(rx_start == UART_RX_BUFF_SIZE)rx_start = 0;

	while(rx_end == rx_start){
	}

	data |= (u32)(rx_buff[rx_start++]) << 16;

	if(rx_start == UART_RX_BUFF_SIZE)rx_start = 0;

	while(rx_end == rx_start){
	}

	data |= rx_buff[rx_start++] << 8;

	if(rx_start == UART_RX_BUFF_SIZE)rx_start = 0;

	while(rx_end == rx_start){
	}

	data |= rx_buff[rx_start++];
	
	return data;
	
}

inline void uartTX(u8 data){

	while(!(UCSRA & 0b00100000)){
	}

	UDR = data;
}

inline void uartTX16(u16 data){
	
	while(!(UCSRA & 0b00100000)){
	}

	UDR = data >> 8;

	while(!(UCSRA & 0b00100000)){
	}

	UDR = data;
}


SIGNAL (SIG_UART_RECV){

	rx_buff[rx_end++] = UDR;
	if(rx_end == UART_RX_BUFF_SIZE)rx_end = 0;

}
