


#include "types.h"
#include "sega_mode.h"
#include "device_control.h"

#define SELECT_MODE_NO 0xff
#define SELECT_MODE_RESET 1
#define SELECT_MODE_LOADER 2

#define GAME_SELECT_MODE 1
#define GAME_NUM 2
#define ROM_ADDRS 3
#define ROM_LENS 35

void segaMode();
inline void setGame(u8 game_idx);
void waitLoderSelection();
void waitResetSelection();
void changeLed();

u8 rom_addr[32];
u8 rom_len[32];
u8 game_num;
u8 game_select_mode;
u8 selected_game;
u8 led_strobe;

void startSegaMode(){
	
	u8 i;
	SET_PORT_STATE_SEGA;
	LED1;
	led_strobe = 1;
	
	game_select_mode = eeprom_read_byte((uint8_t*)GAME_SELECT_MODE);
	
	if(game_select_mode != SELECT_MODE_NO){
		game_num = eeprom_read_byte((u8*)GAME_NUM);
		for(i = 0; i < 32; i++){

			rom_addr[i] = eeprom_read_byte((u8*)(ROM_ADDRS+i));
			rom_len[i] = eeprom_read_byte((u8*)(ROM_LENS+i));
		}
		selected_game = 0;
	}

	segaMode();
}


void segaMode(){
	
	u16 ctr = 0;

	
	while(game_select_mode == SELECT_MODE_NO);
	
	if(game_select_mode == SELECT_MODE_RESET){
		
		for(;;)waitResetSelection();

	}



	if(game_select_mode == SELECT_MODE_LOADER){
		
		for(;;)waitLoderSelection();

	}

	for(;;){
		
		ctr++;
		if(ctr < 32768)LED1; else LED0;
		sleep16;
		sleep16;
		
	}

}

inline void setGame(u8 game_idx){
	
	u8 ddr_mask = rom_len[game_idx];
	ddr_mask -= 1;
	ddr_mask = ~ddr_mask;
	ddr_mask <<= 2;
	ddr_mask &= 0b01111100;

	u8 address_mask = rom_addr[game_idx];
	address_mask <<= 2;
	address_mask &= 0b01111100;

	DDRA = ddr_mask;
	PORTA = address_mask;
}

void waitLoderSelection(){
	
	u8 ce_we;

	setGame(0);
	while(!RESET_STATE);

	LED1;	
	for(;;){
		ce_we = PIND;
		selected_game = PINB;
		ce_we &= 0b10000100;
		if(!ce_we){
			setGame(selected_game);
			MAKE_RESET;
			break;
		}
	}
	PORTA |= 128;
	LED0;
	while(RESET_STATE);
	DDRA = 0;
	
}
void waitResetSelection(){
	
	changeLed();
	setGame(selected_game);
	selected_game++;
	if(selected_game >= game_num)selected_game = 0;
	while(!RESET_STATE);
	while(RESET_STATE);
	
}


void changeLed(){
	
	
	if((led_strobe & 1)){
		LED1;
	}else{
		LED0;
	}
	led_strobe++;
	
}
