
#include <avr/eeprom.h>
#include <avr/io.h>
#include "delay.h"

#define sbit(src, bit)( src |= (1 << bit))
#define cbit(src, bit)( src &= ~(1 << bit))
#define bit(src, bit)(src & (1 << bit))


#define LED0 PORTC &= ~1
#define LED1 PORTC |= 1

#define RY (PINC & (1 << 7))

#define CE1 sbit(PORTD, 2)
#define CE0 cbit(PORTD, 2)


#define OE1 sbit(PORTD, 3)
#define OE0 cbit(PORTD, 3)

#define WE1 sbit(PORTD, 4)
#define WE0 cbit(PORTD, 4)

#define LATCH0 sbit(PORTD, 5);cbit(PORTD, 5)
#define LATCH1 sbit(PORTD, 6);cbit(PORTD, 6)

#define ADDR_BUS_ON cbit(PORTC, 6)
#define ADDR_BUS_OFF sbit(PORTC, 6)
#define ADDR_PORT_ON DDRA = 0xff


#define SET_ADDR(maddr)		\
{							\
 	PORTA = (u8)maddr;		\
	LATCH0;					\
	PORTA = maddr >> 8;		\
	LATCH1;					\
	PORTA = maddr >> 16;	\
}

#define SET_16BIT sbit(PORTC, 1)
#define SET_8BIT cbit(PORTC, 1)

#define MAKE_RESET			\
{							\
	sbit(PORTA, 7);			\
	sbit(DDRA, 7);			\
	cbit(PORTA, 7);			\
	sleep16;				\
	sbit(PORTA, 7);			\
	cbit(DDRA, 7);			\
}

#define RESET_STATE (PINA & (1 << 7))
#define CE_STATE (PIND & (1 << 2))
#define WE_STATE (PIND & (1 << 7))


#define SET_PORT_STATE_USB 	\
{							\
	DDRA = 0;				\
	DDRB = 0;				\
	DDRC = 0;				\
	DDRD = 0;				\
	PORTA = 0;				\
	PORTB = 0;				\
	PORTC = 0;				\
	PORTD = 0;				\
	CE1;					\
	OE1;					\
	WE1;					\
	DDRD = 0b01111100; 		\
	LATCH0;					\
	LATCH1;					\
	DDRC = 0b01000011; 		\
	sbit(PORTC,7);			\
}

#define SET_PORT_STATE_SEGA	\
{							\
	DDRA = 0;				\
	DDRB = 0;				\
	DDRC = 0;				\
	DDRD = 0;				\
	PORTA = 0;				\
	PORTB = 0;				\
	PORTC = 0;				\
	PORTD = 0;				\
	CE1;					\
	OE1;					\
	WE1;					\
	sbit(PORTA, 7);			\
	PORTB = 0xFF;			\
	sbit(DDRC, 0);			\
}


//write byte to flash memory
#define WMEM(addr, data)	\
{							\
	SET_ADDR(addr);			\
	PORTB = data;			\
	CE0;					\
	WE0;					\
	sleep2;					\
	WE1;					\
	CE1;					\
}


//write byte to flash memory without addres setup
#define WMEM_NA(data)	\
{							\
	PORTB = data;			\
	CE0;					\
	WE0;					\
	sleep2;					\
	WE1;					\
	CE1;					\
}

#define RMEM(addr, data)	\
{							\
	SET_ADDR(addr);			\
	CE0;					\
	OE0;					\
	sleep2;					\
	data = PINB;			\
	OE1;					\
	CE1;					\
}


#define DATA_BUS_TO_RX DDRB = 0; PORTB = 0xff
#define DATA_BUS_TO_TX DDRB = 0xFF
