﻿using System;
using System.Collections.Generic;
using System.Text;
using everdrive3x.Hardware;

namespace everdrive3x.Rom
{
    class RomHeader
    {
        public static RomInterface getHeader(Device device)
        {

            return getSegaHeader(device);
        }

        static RomInterface getSegaHeader(Device device)
        {
            byte[] header = new byte[131072];
            device.Control.setAddr(0);
            device.Control.resetByPass();
            int block_len = 4096;

 
            for (int i = 0; i < header.Length; i += block_len)
            {
                System.Array.Copy(device.Control.readBlock(block_len), 0, header, i, block_len);
            }

 
            try
            {
                return new SnesRom(header, 0, header.Length);
            }
            catch (Exception)
            {
            }

            if (N64Rom.getRomType(header, 0) != null)
            {
                return new N64Rom(header, 0, header.Length);
            }
            else
            {
                return new SegaRom(header, 0, header.Length);
            }

        }
    }

}
