﻿using System;
using System.Collections.Generic;
using System.Text;

namespace everdrive3x.Fusion
{
    class FusionRomset
    {

        public const int BANK_LEN = 262144;
        public const int BANK_NUM = 32;

        FusionRom[] romset;
        int rom_num;
        

        public FusionRomset()
        {
            romset = new FusionRom[BANK_NUM];
        }

        public void addRom(FusionRom rom)
        {
            if (rom_num == BANK_NUM) throw new Exception();
            if (rom.IsLoader)
            {
                for (int i = rom_num; i > 0; i--)
                {
                    romset[i] = romset[i - 1];
                }
                romset[0] = rom;
                rom_num++;
            }
            else
            {
                romset[rom_num++] = rom;
            }
        }

        public void removeRom(int idx)
        {
            if (rom_num == 0 || idx >= BANK_NUM) throw new Exception();
            if (romset[idx] == null) throw new Exception();
            romset[idx] = null;
            for (int i = idx; i < rom_num - 1; i++) romset[i] = romset[i + 1];
            romset[rom_num] = null;
            rom_num--;
        }

        public void removeRom(FusionRom rom)
        {
            for (int i = 0; i < rom_num; i++)
            {
                if (romset[i].Equals(rom))
                {
                    removeRom(i);
                    break;
                }
            }
        }

        public int RomsetBinLen
        {
            get
            {
                int len = 0;
                for (int i = 0; i < rom_num; i++) len += romset[i].Binary.Length;
                return len;
            }
        }

        public FusionRom[] GetRomset
        {
            get
            {
                FusionRom[] buff = new FusionRom[rom_num];
                for (int i = 0; i < rom_num; i++) buff[i] = romset[i];
                return buff;
            }
        }

        
        
    }
}
