﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace everdrive3x.Fusion
{
    public partial class FusionForm : Form
    {

        const byte SELECT_MODE_RESET = 1;
        const byte SELECT_MODE_LOADER = 2;
        FusionRomset romset;
        static FusionRom loader;

        public FusionForm()
        {
            InitializeComponent();
            romset = new FusionRomset();
            try
            {
                if (loader == null)
                {
                    loader = new FusionRom("game_menu.bin", "default");
                    loader.IsLoader = true;
                }
            }
            catch (Exception)
            {
            }

        }

        private void button_add_Click(object sender, EventArgs e)
        {

            openFileDialog1 = new OpenFileDialog();
            openFileDialog1.ShowDialog();
            if (openFileDialog1.FileName.Length > 0)
            {
                try
                {
                    FusionRom rom = new FusionRom(openFileDialog1.FileName, "default");
                    romset.addRom(rom);
                    listBox_rom_list.Items.Clear();
                    listBox_rom_list.Items.AddRange(romset.GetRomset);
                    textBox_pack_size.Text = "" + romset.RomsetBinLen / 1024 + "kb";
                    listBox_rom_list.SelectedIndex = listBox_rom_list.Items.Count - 1;
                }
                catch (Exception)
                {

                }
            }


        }


        private void button_remove_Click(object sender, EventArgs e)
        {
            if (listBox_rom_list.SelectedItem == null) return;
            if (listBox_rom_list.SelectedItem.Equals(loader))
            {
                checkBox_game_loader.Checked = false;
                return;
            }
            try
            {
                romset.removeRom(listBox_rom_list.SelectedIndex);
                listBox_rom_list.Items.Clear();
                listBox_rom_list.Items.AddRange(romset.GetRomset);
                textBox_pack_size.Text = "" + romset.RomsetBinLen / 1024 + "kb";
                //listBox_rom_list.SelectedIndex = listBox_rom_list.Items.Count - 1;
            }
            catch (Exception)
            {
            }

        }



        private void checkBox_game_loader_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBox_game_loader.Checked)
            {
                try
                {
                    romset.addRom(loader);
                    listBox_rom_list.Items.Clear();
                    listBox_rom_list.Items.AddRange(romset.GetRomset);
                    textBox_pack_size.Text = "" + romset.RomsetBinLen / 1024 + "kb";
                }
                catch (Exception)
                {
                    checkBox_game_loader.Checked = false;
                    return;
                }
            }
            else
            {
                try
                {
                    romset.removeRom(loader);
                    listBox_rom_list.Items.Clear();
                    listBox_rom_list.Items.AddRange(romset.GetRomset);
                    textBox_pack_size.Text = "" + romset.RomsetBinLen / 1024 + "kb";
                }
                catch (Exception)
                { }
            }

        }

        private void button_make_fusion_Click(object sender, EventArgs e)
        {

            saveFileDialog1 = new SaveFileDialog();
            saveFileDialog1.ShowDialog();
            if (saveFileDialog1.FileName.Length < 1)
            {
                return;
            }
            System.IO.FileStream fs = new System.IO.FileStream(saveFileDialog1.FileName, System.IO.FileMode.Create);
            FusionApp fus = new FusionApp(romset);

            fs.WriteByte((byte)'M');
            fs.WriteByte((byte)'D');
            fs.WriteByte((byte)'F');
            fs.WriteByte((byte)'U');
            fs.WriteByte((byte)'S');

            fs.WriteByte((byte)(2 + fus.Header.Length));
            if (checkBox_game_loader.Checked)
            {
                fs.WriteByte(SELECT_MODE_LOADER);
            }
            else
            {
                fs.WriteByte(SELECT_MODE_RESET);
            }

            fs.WriteByte((byte)romset.GetRomset.Length);
            fs.Write(fus.Header, 0, fus.Header.Length);
            fs.Write(fus.RomData, 0, fus.RomData.Length);
            fs.Close();

        }

        private void button_rename_Click(object sender, EventArgs e)
        {
            if (listBox_rom_list.SelectedItem == null) return;
            RenameForm rf = new RenameForm();
            rf.NewName = listBox_rom_list.SelectedItem.ToString();
            rf.ShowDialog();
            ((FusionRom)listBox_rom_list.SelectedItem).Name = rf.NewName;
            listBox_rom_list.Items.Clear();
            listBox_rom_list.Items.AddRange(romset.GetRomset);
            listBox_rom_list.SelectedIndex = listBox_rom_list.Items.Count - 1;
        }


    }
}
