﻿using System;
using System.Collections.Generic;
using System.Text;

namespace everdrive3x.Hardware
{
    class ProfileSN64 : DeviceProfile
    {
        int firmware_version;

        public ProfileSN64(int firm_ver)
        {
            firmware_version = firm_ver;
        }

        public String Name
        {
            get { return DeviceList.NAME_SNES_64; }
        }

        public int MemorySize
        {
            get { return 8388608; }
        }

        public String PlatformName
        {
            get { return PlatformList.NAME_SNES; }
        }
        public int PlatformID
        {
            get { return PlatformList.ID_SNES; }
        }

        public int FirmwareVersion
        {
            get { return firmware_version; }
        }

        public int ID
        {
            get { return DeviceList.ID_SNES64; }
        }

        public bool MultiGameSupport
        {
            get { return false; }
        }

        public bool ResetLoaderSupport
        {
            get { return false; }
        }

        public bool SoftLoaderSupport
        {
            get { return false; }
        }

        public bool BlockEraseSupport
        {
            get { return true; }
        }

        public bool OnboardProgrammer
        {
            get { return false; }
        }
    }
}
