﻿using System;
using System.Collections.Generic;
using System.Text;

namespace everdrive3x.Hardware
{
    class ProfileED64R2 : DeviceProfile
    {

        protected int firmware_version;

        public ProfileED64R2(int firm_ver)
        {
            firmware_version = firm_ver;
        }

        public virtual String Name
        {
            get { return DeviceList.NAME_ED64R2; }
        }

        public virtual int MemorySize
        {
            get { return 8388608; }
        }

        public String PlatformName
        {
            get { return PlatformList.NAME_SEGA; }
        }
        public int PlatformID
        {
            get { return PlatformList.ID_SEGA; }
        }

        public int FirmwareVersion
        {
            get { return firmware_version; }
        }

        public virtual int ID
        {
            get { return DeviceList.ID_ED64R2; }
        }

        public bool MultiGameSupport
        {
            get { return true; }
        }

        public bool ResetLoaderSupport
        {
            get { return true; }
        }

        public bool SoftLoaderSupport
        {
            get { return true; }
        }

        public bool BlockEraseSupport
        {
            get { return true; }
        }

        public bool OnboardProgrammer
        {
            get { return true; }
        }
    }
}
