/* 
 * File:   main.c
 * Author: KRIK
 *
 * Created on 24  2009 ., 5:20
 */

#include "genesis.h"



#define MAX_STR_LEN 32
#define PAGE_SIZE 16
#define LIST_Y 8
#define LIST_X 2
#define TEXT_PLAN APLAN
#define WALL_PLAN BPLAN



u16 selected_game;
s8 game_selector;
s8 page_selector;
u8 page_size;
u8 total_games;
u8 total_pages;


void startGame();
void cleanHardware();
void initLoader();
void changePage(u8 dir);
void changeSelector(s8 dir);

u8 *header_ptr;
const u8 def_reg_state[] = {
    0x04, 0x04, 0x30, 0x2c, 0x07, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0x2b, 0x00, 0x02, 0x01, 0x00, 0x00, 0xff, 0xff
};

u8 str_buff[16];

asm(".align 16");
asm(".globl wall");
asm("wall:");
asm(".incbin \"wall.bin\"");
extern u32 wall[];

asm(".align 16");
asm(".globl wall_pal");
asm("wall_pal:");
asm(".incbin \"wall_pal.bin\"");
extern u16 wall_pal[16];


int main() {
	
	u8 i;
	cleanHardware();
	VDP_init();
	PSG_init();
	JOY_init();
	VDP_setPalette(0, palette_black);

    u16 joy;
	VDP_drawText(TEXT_PLAN, "                                      ", 0, 0, 1);
    VDP_drawText(TEXT_PLAN, "          SEGA game loader v1.01      ", 0, 0, 2);
    VDP_drawText(TEXT_PLAN, "             http://krikzz.com        ", 0, 0, 3);
    VDP_drawText(TEXT_PLAN, "                                      ", 0, 0, 4);

    initLoader();
    changePage(0);
    VDP_drawText(TEXT_PLAN, ">", 0, LIST_X, LIST_Y + game_selector);
	VDP_setPalette(1, wall_pal);
	VDP_loadTileTo(wall, 1, 28 * 40, 0);
	VDP_fillTileRectInc(WALL_PLAN, TILE_ATTR(1,0,0,0)+1, 0, 0, 40, 28);
	
	for(i = 0;i < 16;i++)VDP_setPaletteColor(2,i,0x0888);
    VDP_setPalette(0, palette_grey);

    for (;;) {

        joy = JOY_readJoypad(JOY_1);

        if ((joy & BUTTON_UP)) {
            changeSelector(-1);
        }
        if ((joy & BUTTON_DOWN)) {
            changeSelector(+1);
        }

		if(total_pages > 1){

			if ((joy & BUTTON_LEFT)) {
				changePage(-1);
			}
			if ((joy & BUTTON_RIGHT)) {
				changePage(+1);
			}
		}

        if ((joy & BUTTON_START)) {

            selected_game = page_selector * PAGE_SIZE + game_selector + 1;
            cleanHardware();
			for(;;)asm("move.w  selected_game, 0x200000");
        }

    }

    return 0;

}

void changeSelector(s8 dir){

	VDP_setTile(TEXT_PLAN, 0, LIST_X, LIST_Y + game_selector);
	game_selector += dir;
	if (game_selector < 0)game_selector = page_size - 1;
	if(game_selector >= page_size)game_selector = 0;
	VDP_drawText(TEXT_PLAN, ">", 0, LIST_X, LIST_Y + game_selector);
	while ((JOY_readJoypad(JOY_1) & BUTTON_UP) || (JOY_readJoypad(JOY_1) & BUTTON_DOWN));
}


void cleanHardware() {

    u16 i;
    VDP_fillTileRect(APLAN, 0, 0, 0, 40, 28);
    VDP_fillTileRect(BPLAN, 0, 0, 0, 40, 28);
    YM2612_reset();
    Z80_startReset();
    for (i = 0; i < sizeof (def_reg_state); i++) {
        VDP_setReg(i, def_reg_state[i]);
    }
}

void initLoader() {

    u8 i;
    header_ptr = (u8 *) 65536;

    selected_game = 0;
    game_selector = 0;
    page_selector = 0;

    for (i = 0; i < 32; i++) {

        if (header_ptr[i * MAX_STR_LEN] == 0) {
            break;
        }
        total_games++;
    }
    if (total_games == 0)total_games = 1;
	total_pages = total_games / PAGE_SIZE;
	if(total_games % PAGE_SIZE != 0)total_pages += 1;
}

void changePage(u8 dir) {

	
	page_selector += dir;
	if(page_selector < 0)page_selector = total_pages - 1;
	if(page_selector >= total_pages)page_selector = 0;
	u16 i;
	u8 offset = page_selector * PAGE_SIZE;
    page_size = total_games - offset;
    if (page_size > PAGE_SIZE)page_size = PAGE_SIZE;
	VDP_fillTileRect(TEXT_PLAN, 0, 0, 6, 40, 21);
    for (i = 0; i < page_size; i++) {

        VDP_drawText(TEXT_PLAN, &header_ptr[offset * MAX_STR_LEN + i * MAX_STR_LEN], 0, LIST_X + 1, LIST_Y + i);
    }
	if(game_selector >= page_size){
		game_selector = page_size - 1;
	}
	changeSelector(0);
	if(total_pages > 1){
		str_buff[0] = (u8)(page_selector + 49);
		str_buff[1] = 0;
		VDP_drawText(TEXT_PLAN, "              < select page >         ", TILE_ATTR(2,0,0,0), 0, 26);
		VDP_drawText(TEXT_PLAN, "  page:", TILE_ATTR(2,0,0,0), 0, 26);
		VDP_drawText(TEXT_PLAN, str_buff, TILE_ATTR(2,0,0,0), sizeof("  page:"), 26);
	}	

	while ((JOY_readJoypad(JOY_1) & BUTTON_LEFT) || (JOY_readJoypad(JOY_1) & BUTTON_RIGHT));
}


