﻿using System;
using System.Collections.Generic;
using System.Text;
using everdrive3x.Hardware;
using everdrive3x.Misc;
using System.IO;

namespace everdrive3x.Rom
{
    class RomTools
    {
      

        public static String getRomExtension(Device device)
        {
            switch (device.Profile.PlatformID)
            {
                case PlatformList.ID_SEGA:
                    return "bin";
                default:
                    return "dat";
            }
        }

        public static RomInterface loadrRom(String file_name)
        {
            RomInterface rom = null;
            byte[] buff = null;

            if (ZipFile.isZip(file_name))
            {
                buff = ZipFile.load(file_name);
            }
            else
            {
                FileStream file = File.OpenRead(file_name);
                buff = new byte[file.Length];
                file.Read(buff, 0, buff.Length);
                file.Close();
            }

            rom = new SegaRom(buff, 0, buff.Length);
            return rom;
        }


        
    }
}
