﻿using System;
using System.Collections.Generic;
using System.Text;
using everdrive3x.Hardware;

namespace everdrive3x.Rom
{
    class RomHeader
    {
        public static RomInterface getHeader(Device device)
        {

            return getSegaHeader(device);
        }

        static RomInterface getSegaHeader(Device device)
        {
            byte[] header = new byte[1024];
            device.Control.setAddr(256);
            device.Control.resetByPass();
            for (int i = 0; i < 6; i++)
            {
                System.Array.Copy(device.Control.readBlock(128), 0, header, 256 + i * 128, 128);
            }
            SegaRom rom = new SegaRom(header, 0, header.Length);

            return rom;
        }
    }

}
