
#include <avr/io.h>
#include "types.h"
#include "uart.h"
#include "control.h"


void uartInit(){
	
	UCSRA |=(1<<U2X);
	UBRRH = (F_CPU/(UART_BAUDRATE * 8L)-1) >> 8;
	UBRRL = (uint8_t)(F_CPU/(UART_BAUDRATE * 8L)-1);
	UCSRB = (1 << RXEN) | (1 << TXEN);
	UCSRC = (1 << URSEL) | (3 << UCSZ0);
}


inline u8 uartRX(){
	

	while(!(UCSRA & (1 << RXC))){
		EXIT_BOOT_IF_RESET;
	}
	
	return UDR;
}

u16 uartRX16(){
	
	u16 data;

	data = uartRX() << 8;
	data |= uartRX();
	
	return data;
	
}

u32 uartRX32(){
	
	u32 data;

	data = (u32)(uartRX()) << 24;
	data |= (u32)(uartRX()) << 16;
	data |= uartRX() << 8;
	data |= uartRX();
	
	return data;
}

void uartTX(u8 data){

	while(!(UCSRA & 0b00100000)){
	}

	UDR = data;
}

void uartTX16(u16 data){
	
	while(!(UCSRA & 0b00100000)){
	}

	UDR = data >> 8;

	while(!(UCSRA & 0b00100000)){
	}

	UDR = data;
}
